#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]
using namespace Rcpp;

// [[Rcpp::export]]
arma::colvec getMusr(const List & Astar,
                     const arma::mat & Dmat,
                     const arma::colvec & alphak,
                     const arma::cube & tau,
                     const arma::mat & SigInv,
                     const arma::mat & X,
                     const arma::colvec & BsBr,
                     const arma::mat & Sigsr){
  int n = Dmat.n_rows;
  int n1 = alphak.n_rows;
  arma::colvec musr = arma::zeros(2*n);
  
  arma::mat temp = arma::zeros(n,n);
  arma::mat temp1 = arma::zeros(n,n);
  
  for(int k=0;k<n1;k++){
    SEXP ll = Astar[k];
    temp = Rcpp::as<arma::mat>(ll) - alphak(k) + Dmat;
    temp1 = temp*tau.slice(k);
    musr.rows(0,n - 1) = musr.rows(0,n - 1) +
      temp1.diag();
    temp1 = temp.t()*tau.slice(k);
    musr.rows(n, 2*n - 1) = musr.rows(n, 2*n - 1) +
      temp1.diag();
  }
  musr = musr + kron(SigInv,X)*BsBr;
  musr = Sigsr*musr;
  
  return musr;
}
