#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]
using namespace Rcpp;

// [[Rcpp::export]]
arma::cube cUpdateTauWithBeta0(const arma::cube & tau,
                               const arma::colvec & beta0New,
                               const arma::colvec & beta0Old){
  int n1 = tau.n_slices;
  int n = tau.n_rows;
  arma::cube tauNew = arma::zeros(n,n,n1);
  
  for(int k=0;k<n1;k++){
    tauNew.slice(k) = tau.slice(k)*beta0New(k)/beta0Old(k);
  }
  
  return tauNew;
}
