#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]
using namespace Rcpp;

// [[Rcpp::export]]
arma::cube getTau(const arma::colvec & beta0k,
                  const double & beta1, 
                  const arma::mat & Dmat,
                  const IntegerVector & kIndex){
  int n = Dmat.n_cols;
  int n1 = beta0k.n_rows;
  arma::cube tau = arma::zeros(n,n,n1);
  
  for(int k=0;k<n1;k++){
    for(int i=0;i<n - 1;i++){
      for(int j=i + 1;j<n; j++){
        tau(i,j,k) = 
          beta0k(k)*exp(-beta1*(Dmat(kIndex(k),i) + Dmat(kIndex(k),j)));
        tau(j,i,k) = tau(i,j,k);
      }
    }
  }
  
  return tau;
}
