#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]
using namespace Rcpp;

// [[Rcpp::export]]
Rcpp::List cUzMz(const double & sigma2Z,
                 const arma::mat & XtX,
                 const double & s2Bz,
                 const arma::mat X,
                 const arma::mat Z){
  int qq = X.n_cols;
  int p = Z.n_cols;
  arma::mat Uz = arma::inv_sympd(XtX/sigma2Z + arma::eye(qq,qq)/s2Bz);
  arma::mat Mz = Uz*X.t()*Z/sigma2Z;
  
  arma::mat Bz = arma::randn(qq,p);
  arma::mat UzCh = arma::chol(Uz);
  
  for(int ell=0;ell<p;ell++){
    Bz.col(ell) = Mz.col(ell) + UzCh.t()*Bz.col(ell);
  }
  
  
  return List::create(Named("Uz") = Uz, Named("Mz") = Mz, Named("Bz") = Bz);
}
