#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]
using namespace Rcpp;

// [[Rcpp::export]]
arma::colvec cGetTheta2k(const arma::cube & tau,
                         const List & AstarList,
                         const arma::mat & Dmat,
                         const arma::colvec & SS,
                         const arma::colvec & RR,
                         const arma::colvec & b0k,
                         const arma::colvec & alphak,
                         const double & theta){
  int n = tau.n_cols;
  int n1 = alphak.n_rows;
  arma::colvec theta2k = arma::zeros(n1) + theta;
  arma::mat Astar = arma::zeros(n,n);
  
  for(int k=0;k<n1;k++){
    SEXP ll = AstarList[k];
    Astar = Rcpp::as<arma::mat>(ll);
    for(int i=0;i<n-1;i++){
      for(int j=i+1;j<n;j++){
        theta2k(k) = theta2k(k) +
          tau(i,j,k)/b0k(k)*pow(Astar(i,j) - alphak(k) - SS(i) - RR(j) + Dmat(i,j),2);
        theta2k(k) = theta2k(k) + 
          tau(j,i,k)/b0k(k)*pow(Astar(j,i) - alphak(k) - SS(j) - RR(i) + Dmat(j,i),2);
      }
    }
  }
  
  return theta2k;
}
