% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPostMean.R
\name{getPostMean}
\alias{getPostMean}
\title{LSMNP Posterior Mean}
\usage{
getPostMean(obj, burnin = 0, type = c("Z", "Dist"), thin = 1)
}
\arguments{
\item{obj}{An object returned from LSMNPGibbs()}

\item{burnin}{Integer. The number of initial MCMC iterations to throw out before computing the posterior mean.}

\item{type}{Either 'Z' or 'Dist'.  The former will give the posterior mean of the latent positions, post-processed using the Procrustes transformation.  The latter will give the posterior mean of the distance matrix of the Z's.}

\item{thin}{The number by which to thin the MCMC chain.}
}
\value{
A list.
\describe{
\item{alphak}
\item{sender}
\item{receiver}
\item{Sigma}
\item{alpha}
\item{sigma2}
\item{beta0k}
\item{beta1}
\item{Z}{(If type equals 'Z')}
\item{DMat}{(If type equals 'Dist')}
\item{sigam2Z}
\item{theta}
\item{Bs}
\item{Br}
\item{Bz}
}
}
\description{
This function computes the posterior mean of the parameter estimates
}
\details{
Returns the posterior means for LSMNPGibbs object as a list.  Make sure to first run 'postProcessZ()' and attach to LSMNP obj 'ZProcessed' and 'BzProcessed'
}
