% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIC.LSMNP.R
\name{DIC.LSMNP}
\alias{DIC.LSMNP}
\title{Deviance Information Criterion for the LSMNP}
\usage{
DIC.LSMNP(A, k.index = 1:length(A), obj, obj.pm = NULL, burnin = 0,
  thin = 1)
}
\arguments{
\item{A}{A list of nxn adjacency matrices}

\item{k.index}{A Kx1 integer vector giving the IDs of the respondents.  Should be the same length as A.}

\item{obj}{An object returned from LSMNPGibbs()}

\item{obj.pm}{(optional) An object returned from getPostMean()}

\item{burnin}{Integer. The number of initial MCMC iterations to throw out.}

\item{thin}{The number by which to thin the MCMC chain.}
}
\value{
A list giving the DIC and pD, the effective number of parameters.
}
\description{
This function computes the DIC for the LSMNP model.
}
\details{
Returns the DIC and effective number of parameter. Make sure to first run 'postProcessZ()' and attach to LSMNP obj 'ZProcessed' and 'BzProcessed'
}
