#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]
using namespace Rcpp;

// [[Rcpp::export]]
Rcpp::List getSigBsr(const arma::mat & SigInv,
                     const arma::mat & XtX,
                     const double & s2Bsr,
                     const arma::mat & X,
                     const arma::colvec & sr){
  int qq = X.n_cols;
  arma::mat SigBsrInv = kron(SigInv,XtX) + arma::eye(2*qq,2*qq)/s2Bsr;
  arma::mat SigBsr = inv_sympd(SigBsrInv);
  arma::colvec muBsr = SigBsr*kron(SigInv.t(),X.t())*sr;
  
  return List::create(Named("SigBsrInv") = SigBsrInv,
                      Named("SigBsr") = SigBsr,
                      Named("muBsr") = muBsr);
}
