#include <RcppArmadillo.h>
// [[Rcpp::depends(RcppArmadillo)]]
using namespace Rcpp;

// [[Rcpp::export]]
double cSumMatMultNoDiag(const NumericMatrix & TAU,
                         const NumericMatrix & Ak,
                         const NumericMatrix & ZZ,
                         const NumericVector & SS,
                         const NumericVector & RR){
  double ret =0;
  int n = TAU.ncol();
  for(int i=0;i<n-1;i++){
    for(int j=i+1;j<n;j++){
      ret += TAU(i,j)*(Ak(i,j) - SS(i) - RR(j) + ZZ(i,j));
      ret += TAU(j,i)*(Ak(j,i) - SS(j) - RR(i) + ZZ(j,i));
    }
  }
  return ret;
}
