% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogPost.R
\name{LogPost}
\alias{LogPost}
\title{LSMNP Log Posterior}
\usage{
LogPost(A, X, Astar, k.index, alphak, ss, rr, Z, b0k, b1, tau = NULL, Bs,
  Br, Bz, sigma2Z, alpha, sigma2, Sigma, theta, muA, nuA, gammaSigma2,
  etaSigma2, gammaSig, GammaSig, muB, nuB, gammaZ, etaZ, s2Bsr, s2Bz)
}
\arguments{
\item{A}{A list of nxn adjacency matrices}

\item{X}{A nxp matrix of covariates}

\item{Astar}{A nxn matrix of latent normal random variables for the probit model}

\item{k.index}{A Kx1 integer vector giving the IDs of the respondents.  Should be the same length as A.}

\item{alphak}{A Kx1 numeric vector}

\item{ss}{A nx1 numeric vector}

\item{rr}{A nx1 numeric vector}

\item{Z}{A nxp matrix}

\item{b0k}{A Kx1 numeric vector}

\item{tau}{(optional) A nxnxK array}

\item{Bs}{A qx1 numeric vector}

\item{Br}{A qx1 numeric vector}

\item{Bz}{A qxp matrix}

\item{sigma2Z}{A scalar}

\item{Sigma}{A 2x2 matrix}

\item{theta}{A scalar}

\item{muA}{A scalar}

\item{nuA}{A scalar}

\item{gammaSigma2}{A scalar}

\item{etaSigma2}{A scalar}

\item{gammaSig}{A scalar}

\item{GammaSig}{A 2x2 matrix}

\item{muB}{A scalar}

\item{nuB}{A scalar}

\item{gammaZ}{A scalar}

\item{etaZ}{A scalar}

\item{s2Bsr}{A scalar}

\item{s2Bz}{A scalar}
}
\value{
A scalar providing the log posterior.
}
\description{
Log posterior for LSMNP
}
\details{
This function evaluates the log posterior for the LSMNP model.  Primarily for internal use.
}
