% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSMNPGibbs.R
\name{LSMNPGibbs}
\alias{LSMNPGibbs}
\title{LSMNP Gibbs Sampling}
\usage{
LSMNPGibbs(A, X, k.index = 1:length(A), p = 3, nsims = 1000,
  quickStart = NULL, hyperparms = NULL, tuneZ = 0.01, tuneB = 1,
  tuneTheta = 0.1, burnin = 100, postProcess = TRUE,
  autoTune = burnin, Thin = 100)
}
\arguments{
\item{A}{A list of nxn adjacency matrices}

\item{X}{A nxp matrix of covariates}

\item{k.index}{A Kx1 integer vector giving the IDs of the respondents.  Should be the same length as A.}

\item{p}{The dimension of the latent space}

\item{nsims}{The number of simulations}

\item{quickStart}{A named list giving the starting positions.  Should include 
\describe{
\item{alpha}{ A scalar}
\item{alphak}{ A Kx1 numeric vector}
\item{sender}{ A nx1 numeric vector}
\item{receiver}{ A nx1 numeric vector}
\item{betak0}{ A Kx1 numeric vector}
\item{Z}{ A nxp matrix}
\item{beta1}{ A scalar}
\item{sigma2}{ A scalar}
\item{Sigma}{ A 2x2 spd matrix}
\item{theta}{ A scalar}
\item{sigma2Z}{ A scalar}
\item{Bs}{ A qx1 numeric vector}
\item{Br}{ A qx1 numeric vector}
\item{Bz}{ A qxp matrix}
}}

\item{hyperparms}{A named list giving the hyperparameters.  Should include 
\describe{
\item{muA}{ A scalar (default = 0)}
\item{nuA}{ A scalar (default = 100)}
\item{gammaSigma2}{ A scalar (default = 0.001)}
\item{etaSigma2}{ A scalar (default = 0.001)}
\item{gammaSig}{ A scalar (default = 2)}
\item{GammaSig}{ A 2x2 matrix (default = 0.001*diag(2))}
\item{muTheta}{ A scalar (default = 0)}
\item{nuTheta}{ A scalar (default = 3)}
\item{muB}{ A scalar (default = 0)}
\item{nuB}{ A scalar (default = 3)}
\item{gammaZ}{ A scalar (default = 0.001)}
\item{etaZ}{ A scalar (default = 0.001)}
\item{s2Bsr}{ A scalar (default = 100)}
\item{s2Bz}{ A scalar (default = 100)}
}}

\item{tuneZ}{Scalar. Initial tuning parameter for Z (will be updated for better acceptance rate through burn-in).}

\item{tuneB}{Scalar. Initial tuning parameter for beta1 (will be updated for better acceptance rate through burn-in).}

\item{tuneTheta}{Scalar. Initial tuning parameter for theta (will be updated for better acceptance rate through burn-in).}

\item{burnin}{Integer. Number of Gibbs iterations to autotune.  Note that these iterations will still be returned.}

\item{postProcess}{Logical. Should procrustes transformation be used?}

\item{autoTune}{Integer.  Number of iterations completed before checking acceptance rate.  To avoid auto-tuning, set to some integer larger than burnin.}

\item{Thin}{Integer.  Only every Thin-th draw will be kept.}
}
\value{
A list.
\describe{
\item{alphak}{MCMC draws}
\item{sender}{MCMC draws}
\item{receiver}{MCMC draws}
\item{Sigma}{MCMC draws}
\item{alpha}{MCMC draws}
\item{sigma2}{MCMC draws}
\item{beta0k}{MCMC draws}
\item{beta1}{MCMC draws}
\item{Z}{MCMC draws}
\item{sigam2Z}{MCMC draws}
\item{theta}{MCMC draws}
\item{Bs}{MCMC draws}
\item{Br}{MCMC draws}
\item{Bz}{MCMC draws}
\item{logPostTrace}{Trace of the log posterior}
\item{tuners}{Tuning parameter values used after the burn-in period.}
\item{accRate}{Acceptance rates for after burn-in period.}
\item{hyperparms}{Hyperparameters used.}
}
}
\description{
The Latent Space Model for Network Perceptions (LSMNP) is a probit model that is fully described in Sewell 2019+.
}
\details{
Perform Gibbs sampling for the LSM for network perception data
}
